/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */
/*global $, window, location, CSInterface, SystemPath, themeManager*/

(function main () {
  'use strict';

  var MM_TO_PT = 0.352777778,
      PT_TO_MM = 2.834645668;

  // Reloads extension panel
  function reloadPanel () {
    location.reload ();
  }

  var csInterface = new CSInterface ();

  function loadJSX (fileName) {
    var extensionRoot = csInterface.getSystemPath (SystemPath.EXTENSION) + "/jsx/";
    csInterface.evalScript ('$.evalFile("' + extensionRoot + fileName + '")');
  }

  function init () {

    themeManager.init ();

    loadJSX ("json2.js");

    if (document.cookie) {
      loadValFromCookies ();
    } else {
      setDefValues ();
    }

    var opts = makeOpts ();

    var mm                 = document.getElementById ('add_mm'),
        content_base       = document.getElementById ('content_base'),
        content_geometry   = document.getElementById ('content_geometry'),
        content_color_font = document.getElementById ('content_color_font'),
        tab_base           = document.getElementById ('tab_base'),
        tab_geometry       = document.getElementById ('tab_geometry'),
        tab_color_font     = document.getElementById ('tab_color_font'),
        measName           = '';

    // latest CC2015 cookies is not working => hide this buttons
    var btn_save = document.getElementById ('btn_save'),
        btn_def  = document.getElementById ('btn_def'),
        aiVers   = 17;
    csInterface.evalScript ('getAiVers()', function (result) {
      //aiVers = JSON.parse (result);
      aiVers = result;
      if (+aiVers < 19) {
        btn_save.className = 'hideElem';
        btn_def.className  = 'hideElem';
      }
    });

    mm.addEventListener ('change', function () {
      if (this.checked == true) {
        opts.units = 'mm';
      } else {
        opts.units = '';
      }
    }, false);

    $ ("#btn_refresh").click (reloadPanel);

    $ ("#btn_top").click (function (event) {
      updateOpts (opts);
      opts.measType = 'linear';
      opts.side     = 'top';
      opts.ctrl     = event.ctrlKey;
      csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
        measName = JSON.parse (result);
      });
    });
    $ ("#btn_bott").click (function (event) {
      updateOpts (opts);
      opts.measType = 'linear';
      opts.side     = 'bott';
      opts.ctrl     = event.ctrlKey;
      csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
        measName = JSON.parse (result);
      });
    });
    $ ("#btn_left").click (function (event) {
      updateOpts (opts);
      opts.measType = 'linear';
      opts.side     = 'left';
      opts.ctrl     = event.ctrlKey;
      csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
        measName = JSON.parse (result);
      });
    });
    $ ("#btn_right").click (function (event) {
      updateOpts (opts);
      opts.measType = 'linear';
      opts.side     = 'right';
      opts.ctrl     = event.ctrlKey;
      csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
        measName = JSON.parse (result);
      });
    });

    $ ("#btn_diam").click (function () {
      updateOpts (opts);
      opts.measType = 'diam';
      csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
        measName = JSON.parse (result);
      });
    });
    $ ("#btn_rad").click (function () {
      updateOpts (opts);
      opts.measType = 'rad';
      csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
        measName = JSON.parse (result);
      });
    });

    $ ("#tab_base").click (function () {
      content_base.className       = "tab-content";
      content_color_font.className = "tab-content hideElem";
      content_geometry.className   = "tab-content hideElem";
      tab_base.className           = "hostButton tab tab-active";
      tab_geometry.className       = "hostButton tab";
      tab_color_font.className     = "hostButton tab";

    });
    $ ("#tab_geometry").click (function () {
      content_base.className       = "tab-content hideElem";
      content_color_font.className = "tab-content hideElem";
      content_geometry.className   = "tab-content";
      tab_base.className           = "hostButton tab";
      tab_geometry.className       = "hostButton tab tab-active";
      tab_color_font.className     = "hostButton tab";
    });
    $ ('#tab_color_font').click (function () {
      content_base.className       = "tab-content hideElem";
      content_color_font.className = "tab-content";
      content_geometry.className   = "tab-content hideElem";
      tab_base.className           = "hostButton tab";
      tab_geometry.className       = "hostButton tab";
      tab_color_font.className     = "hostButton tab tab-active";
    });
    $ ("#tab_other").click (function () {
      content_base.className       = "tab-content hideElem";
      content_color_font.className = "tab-content hideElem";
      content_geometry.className   = "tab-content hideElem";
      tab_base.className           = "hostButton tab";
      tab_geometry.className       = "hostButton tab";
      tab_color_font.className     = "hostButton tab";
    });

    $ ("#btn_save").click (function () {
      updateOpts (opts);
      var faceVal = getFaceVal ();

      for (var key in faceVal) {
        setCookie (key, /*'[' + wtf ( faceVal[ key ] ).slice ( 8 ) +*/ faceVal[key], {expires: 3600 * 30000});
      }
    });

    $ ("#btn_def").click (function () {
      updateOpts (opts);
      var faceVal = getFaceVal ();

      for (var key in faceVal) {
        deleteCookie (key);
      }
      setDefValues ();
    });

    /**
     * CONTROL HENDLERS
     * */

    $ ("#line_len").mousedown (function (e) {

      if (e.shiftKey) {
//        alert(document.getElementById ( 'line_len' ).getAttribute('step'));
        document.getElementById ('line_len').setAttribute ('step', '10');
      } else {
        document.getElementById ('line_len').setAttribute ('step', '1');
      }
    });
    $ ("#line_len").click (function (e) {

      var i = 0;

      if (!measName) {
        /* csInterface.evalScript ( 'measAllSelect(' + JSON.stringify ( opts ) + ')', function ( result ) {
         alert(typeof JSON.parse ( result ));
         } );*/
        return;
      }

      if (opts.measType == 'linear') {

        switch (opts.side) {
          case 'top':
            updateOpts (opts);
            opts.measType = 'linear';
            opts.side     = 'top';
            opts.ctrl     = e.ctrlKey;
            csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
              measName = JSON.parse (result);
            });
            for (i = 0; i < measName.length; i++) {
              csInterface.evalScript ('delMeasByName(' + measName[i] + ',' + i + ')');
            }
            break;
          case 'bott':
            updateOpts (opts);
            opts.measType = 'linear';
            opts.side     = 'bott';
            opts.ctrl     = e.ctrlKey;
            csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
              measName = JSON.parse (result);
            });
            for (i = 0; i < measName.length; i++) {
              csInterface.evalScript ('delMeasByName(' + measName[i] + ')');
            }
            break;
          case 'left':
            updateOpts (opts);
            opts.measType = 'linear';
            opts.side     = 'left';
            opts.ctrl     = e.ctrlKey;
            csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
              measName = JSON.parse (result);
            });
            for (i = 0; i < measName.length; i++) {
              csInterface.evalScript ('delMeasByName(' + measName[i] + ')');
            }
            break;
          case 'right':
            updateOpts (opts);
            opts.measType = 'linear';
            opts.side     = 'right';
            opts.ctrl     = e.ctrlKey;
            csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
              measName = JSON.parse (result);
            });
            for (i = 0; i < measName.length; i++) {
              csInterface.evalScript ('delMeasByName(' + measName[i] + ')');
            }
            break;
          default:
            break;
        }
      } else {
        switch (opts.measType) {
          case 'rad':
            updateOpts (opts);
            opts.measType = 'rad';
            csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
              measName = JSON.parse (result);
            });
            for (i = 0; i < measName.length; i++) {
              csInterface.evalScript ('delMeasByName(' + measName[i] + ')');
            }
            break;
          case 'diam':
            updateOpts (opts);
            opts.measType = 'diam';
            csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
              measName = JSON.parse (result);
            });
            for (i = 0; i < measName.length; i++) {
              csInterface.evalScript ('delMeasByName(' + measName[i] + ')');
            }
            break;
          default:
            break;
        }
      }

    });

    $ ("#font_size").click (function (e) {
      changeMeas (e);
    });
    $ ("#font_size").mousedown (function (e) {

      if (e.shiftKey) {
        document.getElementById ('font_size').setAttribute ('step', '10');
      } else {
        document.getElementById ('font_size').setAttribute ('step', '1');
      }
    });

    $ ("#line_stroke").click (function (e) {
      changeMeas (e);
    });
    $ ("#line_stroke").mousedown (function (e) {

      if (e.shiftKey) {
        document.getElementById ('line_stroke').setAttribute ('step', '1');
      } else {
        document.getElementById ('line_stroke').setAttribute ('step', '0.05');
      }
    });

    $ ("#gap").click (function (e) {
      changeMeas (e);
    });
    $ ("#gap").mousedown (function (e) {

      if (e.shiftKey) {
        document.getElementById ('gap').setAttribute ('step', '10');
      } else {
        document.getElementById ('gap').setAttribute ('step', '0.5');
      }
    });

    $ ("#line_indent").click (function (e) {
      changeMeas (e);
    });
    $ ("#line_indent").mousedown (function (e) {

      if (e.shiftKey) {
        document.getElementById ('line_indent').setAttribute ('step', '10');
      } else {
        document.getElementById ('line_indent').setAttribute ('step', '0.5');
      }
    });

    $ ("#arrow_width").click (function (e) {
      changeMeas (e);
    });
    $ ("#arrow_width").mousedown (function (e) {

      if (e.shiftKey) {
        document.getElementById ('arrow_width').setAttribute ('step', '10');
      } else {
        document.getElementById ('arrow_width').setAttribute ('step', '0.5');
      }
    });

    $ ("#cyan").click (function (e) {
      changeMeas (e);
    });
    $ ("#cyan").mousedown (function (e) {

      if (e.shiftKey) {
        document.getElementById ('cyan').setAttribute ('step', '10');
      } else {
        document.getElementById ('cyan').setAttribute ('step', '1');
      }
    });
    $ ("#magenta").click (function (e) {
      changeMeas (e);
    });
    $ ("#magenta").mousedown (function (e) {

      if (e.shiftKey) {
        document.getElementById ('magenta').setAttribute ('step', '10');
      } else {
        document.getElementById ('magenta').setAttribute ('step', '1');
      }
    });
    $ ("#yellow").click (function (e) {
      changeMeas (e);
    });
    $ ("#yellow").mousedown (function (e) {

      if (e.shiftKey) {
        document.getElementById ('yellow').setAttribute ('step', '10');
      } else {
        document.getElementById ('yellow').setAttribute ('step', '1');
      }
    });
    $ ("#black").click (function (e) {
      changeMeas (e);
    });
    $ ("#black").mousedown (function (e) {

      if (e.shiftKey) {
        document.getElementById ('black').setAttribute ('step', '10');
      } else {
        document.getElementById ('black').setAttribute ('step', '1');
      }
    });

    /*  $ ("#precis").change(function (e) {
     changeMeas (e);
     });*/
    $ ("#precis").click (function (e) {
      changeMeas (e);
    });
    /*   $ ("#add_mm").change(function (e) {
     changeMeas (e);
     });*/
    $ ("#add_mm").click (function (e) {
      changeMeas (e);
    });

    function makeOpts () {
      var precission = document.getElementById ('precis').value;
      if (precission == '0') {
        precission = '00';
      }
      return {
        side    : '',
        strkW   : +(document.getElementById ('line_stroke').value) * PT_TO_MM,
        colComp : [
          +(document.getElementById ('cyan').value),
          +(document.getElementById ('magenta').value),
          +(document.getElementById ('yellow').value),
          +(document.getElementById ('black').value)
        ],
        units   : '',
        arW     : +(document.getElementById ('arrow_width').value) * PT_TO_MM,
        gap     : +(document.getElementById ('gap').value) * PT_TO_MM,
        stopBot : +(document.getElementById ('line_indent').value) * PT_TO_MM,
        stopTop : ((document.getElementById ('line_len').value)) * PT_TO_MM,
        fontSize: +(document.getElementById ('font_size').value),
        precis  : precission.length - 2, // precission - number of signs after comma
        fontNum : 0,
        addLay  : document.getElementById ('add_layer').checked,
        layName : document.getElementById ('layer_name').value,
        mm      : document.getElementById ('add_mm').checked,
        ctrl    : false
      }
    }

    function updateOpts () {
      var precission = document.getElementById ('precis').value;
      if (precission == '0') {
        precission = '00';
      }

      if (document.getElementById ('add_mm').checked) {
        opts.units = 'mm';
      } else {
        opts.units = '';
      }

      opts.strkW    = +(document.getElementById ('line_stroke').value) * PT_TO_MM;
      opts.colComp  = [
        +(document.getElementById ('cyan').value),
        +(document.getElementById ('magenta').value),
        +(document.getElementById ('yellow').value),
        +(document.getElementById ('black').value)
      ];
      opts.arW      = +(document.getElementById ('arrow_width').value) * PT_TO_MM;
      opts.gap      = +(document.getElementById ('gap').value) * PT_TO_MM;
      opts.stopBot  = +(document.getElementById ('line_indent').value) * PT_TO_MM;
      opts.stopTop  = ((document.getElementById ('line_len').value) ) * PT_TO_MM;
      opts.fontSize = +(document.getElementById ('font_size').value);
      opts.precis   = precission.length - 2; // precission - number of signs after comma
      opts.addLay   = document.getElementById ('add_layer').checked;
      opts.layName  = document.getElementById ('layer_name_text').value;
      opts.mm       = document.getElementById ('add_mm').checked;
      opts.ctrl     = false;
    }

    function setDefValues (o) {
      measName                                          = '';
      document.getElementById ('add_mm').checked        = false;
      document.getElementById ('line_stroke').value     = 0.2;
      document.getElementById ('gap').value             = 0.5;
      document.getElementById ('line_indent').value     = 1;
      document.getElementById ('line_len').value        = 10;
      document.getElementById ('arrow_width').value     = 3.5;
      document.getElementById ('font_size').value       = 16;
      document.getElementById ('cyan').value            = 0;
      document.getElementById ('magenta').value         = 100;
      document.getElementById ('yellow').value          = 100;
      document.getElementById ('black').value           = 0;
      document.getElementById ('precis').value          = '0';
      document.getElementById ('add_layer').checked     = true;
      document.getElementById ('layer_name_text').value = '\u6807\u6CE8\u56FE\u5C42';
    }

    function getFaceVal () {
      var d          = document;
      var precission = d.getElementById ('precis').value;
      ( precission == '0' ) ? precission = '00' : precission = precission.length - 2;

      return {
        strkW    : +(d.getElementById ('line_stroke').value),
        colComp_c: +(d.getElementById ('cyan').value),
        colComp_m: +(d.getElementById ('magenta').value),
        colComp_y: +(d.getElementById ('yellow').value),
        colComp_k: +(d.getElementById ('black').value),
        units    : d.getElementById ('add_mm').checked,
        arW      : +(d.getElementById ('arrow_width').value),
        gap      : +(d.getElementById ('gap').value),
        stopBot  : +(d.getElementById ('line_indent').value),
        stopTop  : ((d.getElementById ('line_len').value)),
        fontSize : +(d.getElementById ('font_size').value),
        precis   : precission, // precission - number of signs after comma
        addLay   : d.getElementById ('add_layer').checked,
        layName  : d.getElementById ('layer_name_text').value,
        add_mm   : d.getElementById ('add_mm').checked,
        ctrl     : false
      }
    }

    function loadValFromCookies () {

      var o = _parseCookies ();
      _setVal (o);

      function _setVal (o) {

        if (o.add_mm == 'false') {
          document.getElementById ('add_mm').checked = false;

        } else if (o.add_mm == 'true') {
          document.getElementById ('add_mm').checked = true;
        }

        if (o.addLay == 'true') {
          document.getElementById ('add_layer').checked = true;
        } else {
          o.addLay == false;
        }

        document.getElementById ('line_stroke').value     = o.strkW;
        document.getElementById ('gap').value             = o.gap;
        document.getElementById ('line_indent').value     = o.stopBot;
        document.getElementById ('line_len').value        = o.stopTop;
        document.getElementById ('arrow_width').value     = o.arW;
        document.getElementById ('font_size').value       = o.fontSize;
        document.getElementById ('cyan').value            = o.colComp_c;
        document.getElementById ('magenta').value         = o.colComp_m;
        document.getElementById ('yellow').value          = o.colComp_y;
        document.getElementById ('black').value           = o.colComp_k;
        document.getElementById ('precis').value          = ['0', '0.0', '0.00', '0.000'][+o.precis];
        document.getElementById ('layer_name_text').value = o.layName;
      }

      function _parseCookies () {
        if (document.cookie == '') return;
        var o = {};

        var arr = document.cookie.split ('; ');

        for (var i = 0; i < arr.length; i++) {
          var cook = arr[i];
          var key  = cook.slice (0, cook.indexOf ('='));
          var val  = getCookie (key);
          o[key]   = val;
        }
        return o;
      }
    }

    function getCookie (name) {
      var matches = document.cookie.match (new RegExp (
        "(?:^|; )" + name.replace (/([\.$?*|{}\(\)\[\]\\\/\+^])/g, '\\$1') + "=([^;]*)"
      ));
      return matches ? decodeURIComponent (matches[1]) : undefined;
    }

    /**
     * source http://learn.javascript.ru/cookie
     */
    function setCookie (name, value, options /*expires,path,domain,secure*/) {
      options = options || {};

      var expires = options.expires;

      if (typeof expires == "number" && expires) {
        var d = new Date ();
        d.setTime (d.getTime () + expires * 1000);
        expires = options.expires = d;
      }
      if (expires && expires.toUTCString) {
        options.expires = expires.toUTCString ();
      }

      value = encodeURIComponent (value);

      var updatedCookie = name + "=" + value;

      for (var propName in options) {
        updatedCookie += "; " + propName;
        var propValue = options[propName];
        if (propValue !== true) {
          updatedCookie += "=" + propValue;
        }
      }
      document.cookie = updatedCookie;
    }

    function deleteCookie (name) {
      setCookie (name, "", {expires: -1});
    }

    /**
     * Array, Date, String, Number, Function, Boolean, File, Folder, undefned, Null
     *  @return {String}
     *  */
    function wtf (obj) {
      return ({}.toString.call (obj));
    }

    function changeMeas (e) {

      var i = 0;

      if (!measName) {
        /* csInterface.evalScript ( 'measAllSelect(' + JSON.stringify ( opts ) + ')', function ( result ) {
         alert(typeof JSON.parse ( result ));
         } );*/
        return;
      }

      if (opts.measType == 'linear') {

        switch (opts.side) {
          case 'top':
            updateOpts (opts);
            opts.measType = 'linear';
            opts.side     = 'top';
            opts.ctrl     = e.ctrlKey;
            csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
              measName = JSON.parse (result);
            });
            for (i = 0; i < measName.length; i++) {
              csInterface.evalScript ('delMeasByName(' + measName[i] + ',' + i + ')');
            }
            break;
          case 'bott':
            updateOpts (opts);
            opts.measType = 'linear';
            opts.side     = 'bott';
            opts.ctrl     = e.ctrlKey;
            csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
              measName = JSON.parse (result);
            });
            for (i = 0; i < measName.length; i++) {
              csInterface.evalScript ('delMeasByName(' + measName[i] + ')');
            }
            break;
          case 'left':
            updateOpts (opts);
            opts.measType = 'linear';
            opts.side     = 'left';
            opts.ctrl     = e.ctrlKey;
            csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
              measName = JSON.parse (result);
            });
            for (i = 0; i < measName.length; i++) {
              csInterface.evalScript ('delMeasByName(' + measName[i] + ')');
            }
            break;
          case 'right':
            updateOpts (opts);
            opts.measType = 'linear';
            opts.side     = 'right';
            opts.ctrl     = e.ctrlKey;
            csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
              measName = JSON.parse (result);
            });
            for (i = 0; i < measName.length; i++) {
              csInterface.evalScript ('delMeasByName(' + measName[i] + ')');
            }
            break;
          default:
            break;
        }
      } else {
        switch (opts.measType) {
          case 'cent':
            updateOpts (opts);
            opts.measType = 'cent';
            csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
              measName = JSON.parse (result);
            });
            for (i = 0; i < measName.length; i++) {
              csInterface.evalScript ('delMeasByName(' + measName[i] + ')');
            }
            break;
          case 'rad':
            updateOpts (opts);
            opts.measType = 'rad';
            csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
              measName = JSON.parse (result);
            });
            for (i = 0; i < measName.length; i++) {
              csInterface.evalScript ('delMeasByName(' + measName[i] + ')');
            }
            break;
          case 'diam':
            updateOpts (opts);
            opts.measType = 'diam';
            csInterface.evalScript ('measAllSelect(' + JSON.stringify (opts) + ')', function (result) {
              measName = JSON.parse (result);
            });
            for (i = 0; i < measName.length; i++) {
              csInterface.evalScript ('delMeasByName(' + measName[i] + ')');
            }
            break;
          default:
            break;
        }
      }

    }

  }

  init ();

} ());
